﻿var customExports = {
    datatable: null,
    refreshDataTable: function () {
        customExports.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-customExports").a4datatable({
            ajaxAction: a4.getAction("GetCustomExports", "Panel", "Admin"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Class": "id" },
                { "Name": "PanelId", "Title": resources.PanelId, "Data": "PanelId", "Class": "v-name" },
                { "Name": "PanelName", "Title": resources.PanelName, "Data": "PanelName" },
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "Visible", "Title": resources.Visible, "Data": "Visible", "Label": "VisibleLabel", }
            ],
            defaultSorting: "Id",
            toolBarItems: customExports.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                if (action == "delete") {
                    customExports.deleteItems(ids);
                }
            },
            contextMenuItems: customExports.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        customExports.editItem(row, "false");
                        break;

                    case "delete":
                        customExports.deleteItems(row.Id);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addExport", function () {
            modalDialog.showWindow(a4.getAction("CustomExportEditor", "Panel", "Admin"), 550, 600, {
                afterClose: function () {
                    customExports.refreshDataTable();
                }
            });
        });
    },
    editItem: function (item) {
        modalDialog.showWindow(a4.getAction("CustomExportEditor", "Panel", "Admin", { id: item.Id }), 550, 600, {
            afterClose: function () {
                customExports.refreshDataTable();
            }
        });
    },
    deleteItems: function (items) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        modalDialog.showConfirmDialog(confirmDeleteResources, function () {
            a4.callServerMethod(a4.getAction("DeleteExports", "Panel", "Admin"), { ids: items },
                function (result) {
                    customExports.refreshDataTable();
                });
        }, 250, 400, true, { "count": itemsCount });
    },
    getContextMenuItems: function () {
        var items = [];
        items.push({ "Action": "edit", "Label": resources.Edit });
        items.push({ "Action": "delete", "Label": resources.Delete });
        return items;
    },
    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    }
}

$(document).ready(function () {
    if ($(".v-customExports").length > 0) {
        customExports.initializeDataTable();
        customExports.bindEvents();
    }
});


